/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.action;

import java.sql.SQLException;

import java.util.Date;
import java.util.Map;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dao.MosPUserDao;
import jp.mosp.common.dto.MosPUserDto;
import jp.mosp.common.vo.MosPVo;

import jp.mosp.human.action.HumanKihonCardAction;
import jp.mosp.human.dao.MEmergencyDao;
import jp.mosp.human.dao.MKihonDao;
import jp.mosp.human.dao.MKojinDao;
import jp.mosp.human.dto.MEmergencyDto;
import jp.mosp.human.dto.MKihonDto;
import jp.mosp.human.dto.MKojinDto;
import jp.mosp.human.vo.HumanCardVo;
import jp.mosp.human.vo.HumanKihonCardVo;

import jp.mosp.system.dto.MYakusyokuDto;

public abstract class MosPHumanAction extends MosPAction {

	// tB[h
	protected Map<String, MYakusyokuDto> 	mapPosition;
	protected MYakusyokuDto				mPositionDto;
	protected MKihonDao					mKihonDao;
	protected MKihonDto					mKihonDto;
	protected MKihonDto					storedmKihonDto;

	protected MKojinDao					mKojinDao;	
	protected MKojinDto					mKojinDto;

	protected MEmergencyDao				mEmergencyDao;
	protected MEmergencyDto				mEmergencyDto;	

	/**
	 * l{pDAO
	 */
	protected void prepareHumanBasisDao() {
		// DAO
		if (mKihonDao != null) {
			return;
		}
		mKihonDao = new MKihonDao();
		mKihonDao.initDao(cfg, cmd, aspUser, user, conn);
	}

	/**
	 *lpDAO
	 */
	protected void prepareKojinBasisDao() {
		// DAO
		if (mKojinDao != null) {
			return;
		}
		mKojinDao = new MKojinDao();
		mKojinDao.initDao(cfg, cmd, aspUser, user, conn);
	}

	/**
	 * ً}pDAO
	 */
	protected void prepareEmergencyBasisDao() {
		// DAO
		if (mEmergencyDao != null) {
			return;
		}
		mEmergencyDao = new MEmergencyDao();
		mEmergencyDao.initDao(cfg, cmd, aspUser, user, conn);		
	}

	/**
	 * l{擾
	 * @param kCode       ЈR[h
	 * @param isForUpdate Abvf[gptO
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 * @throws SQLException
	 */
	protected void findHumanBasisInfo(
			String kCode,
			boolean isForUpdate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// l{pDAO
		prepareHumanBasisDao();
		// ݂̏擾
		if (isForUpdate) {
			mKihonDto      = mKihonDao.findForUpdate(kCode);
		} else {
			mKihonDto      = mKihonDao.findForKey(kCode);
		}
	}

	/**
	 * l擾
	 * @param kCode       ЈR[h
	 * @param isForUpdate Abvf[gptO
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 * @throws SQLException
	 */
	protected void findHumanPersonnelInfo(
			String kCode,
			boolean isForUpdate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// lpDAO
		if (mKojinDao != null) {
			return;
		}
		mKojinDao  = new MKojinDao();
		mKojinDao.initDao(cfg, cmd, aspUser, user, conn);
		// ݂̏擾
		if (isForUpdate) {
			mKojinDto = mKojinDao.findForUpdate(kCode);
		} else {
			mKojinDto = mKojinDao.findForKey(kCode);
		}
	}

	/**
	 * ً}A擾
	 * @param kCode       ЈR[h
	 * @param isForUpdate Abvf[gptO
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 * @throws SQLException
	 */
	protected void  findHumanEmergencyInfo(
			String kCode,
			boolean isForUpdate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// ً}ApDAO
		// DAO
		if (mEmergencyDao != null) {
			return;
		}
		mEmergencyDao = new MEmergencyDao();
		mEmergencyDao.initDao(cfg, cmd, aspUser, user, conn);
		mEmergencyDto = new MEmergencyDto();

		String maxEno =	mEmergencyDao.findForMax(kCode);		

		// ݂̏擾
		if (isForUpdate) {			
			mEmergencyDto = mEmergencyDao.findForConditionUp(maxEno,kCode);
		} else {
			mEmergencyDto = mEmergencyDao.findForCondition(maxEno,kCode);
		}

	}	

	/**
	 * ύXe擾
	 * @param kCode ЈR[h
	 * @return ύXe
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 * @throws SQLException
	 */
	protected String getChanging(
			String kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// l{擾
		findHumanBasisInfo(kCode, false);
		// ύXe擾
		StringBuffer sb = new StringBuffer();
		if (mKihonDto == null) {
			sb.append(CommonConst.NAM_MAKE_NEW_DATA);
		} else {
			if (sb.length() > 0) {
				return sb.substring(0, sb.length() - 1);
			}
		}
		return sb.toString();
	}

	/**
	 * [UKp
	 * @param kCode        ЈR[h
	 * @param isBatchApply ꊇKptO(trueFꊇKpAfalseFʓKp)
	 * @return 
	 * @throws Exception
	 */
	protected int applyHistory(String kCode, boolean isBatchApply, MosPVo vo) throws Exception {
		// l{擾
		findHumanBasisInfo(kCode, false);
		// rmF
		if (!isBatchApply && storedmKihonDto != null) {
			chkExclusive(storedmKihonDto, mKihonDto, vo);
		} else {
			// l{擾
			storedmKihonDto = mKihonDao.findForKey(kCode);
		}
		// [U[擾
		MosPUserDao mospuserDao = new MosPUserDao();
		mospuserDao.initDao(cfg, cmd, aspUser, user, conn);
		MosPUserDto mospuserDto = mospuserDao.findForUpdate(kCode);
		// EʃXg擾
		if (mapPosition == null) {
			mapPosition = getPositionMap();
		}
		mPositionDto = mapPosition.get(mKihonDto.getYCode());
		chkExist(mPositionDto);
		// [U
		if (mospuserDto == null) {
			// [U[̍쐬
			mospuserDto = new MosPUserDto();
			mospuserDto.setUserId(kCode);
			mospuserDto.setPassword(MospUtility.getDigest(MospUtility.getDigest(kCode)));
			mospuserDto.setKCode(kCode);
			mospuserDto.setUserName(mKihonDto.getSimei());
			mospuserDto.setAuthority(CommonConst.AUTH_DEFAULT_USER);
			mospuserDto.setChangePass(new Date());
			mospuserDto.setDataLevel(CommonConst.DATA_DEFAULT_LEVEL);
			mospuserDto.setDeleteFlag(mKihonDto.getTsDate() == 0 ? CommonConst.DEFAULT_FLAG_OFF : CommonConst.DEFAULT_FLAG_ON);
			mospuserDao.insert(mospuserDto);
		} else {
			// [U̍XV
			mospuserDto.setUserName(mKihonDto.getSimei());
			mospuserDto.setDeleteFlag(mKihonDto.getTsDate() == 0 ? CommonConst.DEFAULT_FLAG_OFF : CommonConst.DEFAULT_FLAG_ON);
			mospuserDao.update(mospuserDto, true);
		}
		return 1;
	}

	/**
	 * IЈl{擾
	 * @param vo ΏVO
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 * @throws SQLException
	 * @throws MospException
	 */
	protected void getSelectedEmployeeBasis(
			HumanCardVo vo
	) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		// IЈR[h擾
		String kCode = "";
		if (vo.getTxtChangeKCode() != null && !vo.getTxtChangeKCode().equals("") ) {
			kCode = vo.getTxtChangeKCode();
		} else if (key1 != null && !key1.equals("")) {
			kCode = key1;
		} else {
			HumanKihonCardVo kihonVo = (HumanKihonCardVo)getStoredVo(CommonConst.VO_HUMAN_KIHON);
			if (kihonVo == null) {
				// {ʂ֖߂({񂪖ꍇ)
				throwNoBasisException();
			} else {
				kCode = kihonVo.getTxtKCode() == null ? "" : kihonVo.getTxtKCode();
			}
		}
		// l{擾
		findHumanBasisInfo(kCode, false);
		if (mKihonDto == null) {
			// {ʂ֖߂({񂪖ꍇ)
			throwNoBasisException();
		}
		// Ј擾
		if (mKihonDto != null) {
			vo.setLblKCode(mKihonDto.getKCode());
			vo.setLblKName(mKihonDto.getSimei());
			vo.setLblKKana(mKihonDto.getFurigana());
		}
	}

	/**
	 * l{擾s\
	 * @throws MospException
	 */
	protected void throwNoBasisException() throws MospException {
		String errMessage = MospUtility.getMessage(msg, CommonConst.MSG_NO_HUMAN_DATA, "");
		addErrMessage(errMessage);
		setNextCmd(HumanKihonCardAction.CMD_HUMAN_BASIS_SHOW);
		throw new MospException(CommonConst.EX_NO_BASIS, errMessage);
	}

	/**
	 * ZbVێDTO擾
	 */
	protected void getStoredDto() {
		storedmKihonDto = (MKihonDto)session.getAttribute(CommonConst.ATT_MKIHON_DTO);
	}

	/**
	 * ZbVێDTOݒ
	 */
	protected void setStoredDto() {
		session.setAttribute(CommonConst.ATT_MKIHON_DTO, storedmKihonDto);
	}

	/**
	 * {^\ݒ
	 * @param vo	ΏVO
	 */
	protected void setListButton(HumanCardVo vo) {
		vo.setCmdListButton1("H1012");
		vo.setNamListButton1(CommonConst.NAM_TO_HUMAN_LIST);
	}

}
